#!/bin/sh

me="sync-eth0-mac-address.sh"

OTP_MAC0_FILE="/sys/fsl_otp/HW_OCOTP_MAC0"
OTP_MAC1_FILE="/sys/fsl_otp/HW_OCOTP_MAC1"
MAC_ADDR_0_FILE="/opt/extparam/mac_address_0"

OTP_MAC0=""
if [ -r "${OTP_MAC0_FILE}" ]
then
  # read first line of mac0 file (dismisses newline)
  OTP_MAC0=$(head -n 1 "${OTP_MAC0_FILE}")
  # fill zeros up to 8 bytes and converts to upper case
  OTP_MAC0=$(printf %08x "${OTP_MAC0}" | awk '{print toupper($0)}')
else
  logger -s "[${me}]: ${OTP_MAC0_FILE} not readable..."
  exit 1
fi

OTP_MAC1=""
if [ -r "${OTP_MAC1_FILE}" ]
then
  # read first line of mac1 file (dismisses newline)
  OTP_MAC1=$(head -n 1 "${OTP_MAC1_FILE}")
  # fill zeros up to 8 bytes and converts to upper case
  OTP_MAC1=$(printf %08x "${OTP_MAC1}" | awk '{print toupper($0)}')
else
  logger -s "[${me}]: ${OTP_MAC1_FILE} not readable..."
  exit 2
fi

MAC_ADDR_0=""
if [ -r "${MAC_ADDR_0_FILE}" ]
then
  # read first line of MAC address 0 file (dismisses newline) and remove colons
  MAC_ADDR_0=$(head -n 1 "${MAC_ADDR_0_FILE}" | tr -d ':')
else
  logger -s "[${me}]: ${MAC_ADDR_0_FILE} file not readable..."
  exit 3
fi

# put the two separated parts together.
OTP_MAC=$(echo ${OTP_MAC1:4}${OTP_MAC0})

if [ "${OTP_MAC}" == "${MAC_ADDR_0}" ]
then
  logger -s "[${me}]: eth0 MAC address is in sync with OTP registers. Nothing to do."
else
  if [ -z "${OTP_MAC}" ] || [ "${OTP_MAC}" == "000000000000" ]
  then
    logger -s "[${me}]: MAC address not set in OTP registers."
    echo 0x${MAC_ADDR_0:0:4} > /sys/fsl_otp/HW_OCOTP_MAC1
    echo 0x${MAC_ADDR_0:4} > /sys/fsl_otp/HW_OCOTP_MAC0
    ### TODO: ###
    #
    # 1. check, if OTP is empty (and not locked => OTP_LOCK register) - DONE
    # 2. write bytes into OTP_MAC0 and OTP_MAC1 - DONE
    # 2a. what does the bytes 0xbfb3 stand for?
    # 3. If possible set the lock bits, that are for the two MAC registers only - otherwise lock at a later step.
    #
    ###
  else
    logger -s "[${me}]: MAC address is found in OTP registers, but not in extparam's mac_address_0 file. Will update mac_addess_0 now."
    OTP_MAC_WITH_COLONS="${OTP_MAC:0:2}:${OTP_MAC:2:2}:${OTP_MAC:4:2}:${OTP_MAC:6:2}:${OTP_MAC:8:2}:${OTP_MAC:10:2}"
    echo "${OTP_MAC_WITH_COLONS}" > "${MAC_ADDR_0_FILE}"
    TMPMAC=$(head -n 1 "${MAC_ADDR_0_FILE}")
    logger -s "[${me}]: MAC address of eth0 is now updated to [${TMPMAC}]."
  fi
fi

IFCONFIG_MAC=$(ifconfig eth0 | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}' | tr -d ':')
if ! [ "${IFCONFIG_MAC}" == "${OTP_MAC}" ]
then
  logger -s "[${me}] eth0 MAC address is not in sync with kernel module. THIS ERROR NEEDS TO BE CORRECTED IN U-BOOT OR LINUX KERNEL MODULE."
fi

exit 0

