#!/bin/sh

MSPPROG=/opt/gira/bin/mspprogram
MSPFIRM=/opt/gira/share/knxstack/msp/gira_linklayer_msp.a43
IPMODULE_ID_FILE=/opt/extparam/ipmodule_id
MSPPROGRAM_LOGFILE=/var/log/mspprogram.log
MSPFIRM_ACTUAL_HASHFILE=/opt/extparam/actual_msp_firmware.a43.md5
MSPFIRM_EXPECTED_HASHFILE=/opt/gira/share/knxstack/msp/gira_linklayer_msp.a43.md5

# First, check if firmware hashes differ.
# == 0 means that firmware is up-to-date and does NOT need to be programmed.
# != 0 means that firmware differs and needs to be programmed.
# default value is 1 so that firmware differs and needs to be programmed.
MSPFIRM_DIFFERS=1
if [ -e ${MSPFIRM_ACTUAL_HASHFILE} -a -e ${MSPFIRM_EXPECTED_HASHFILE} ]
then
  cmp -s ${MSPFIRM_ACTUAL_HASHFILE} ${MSPFIRM_EXPECTED_HASHFILE}
  MSPFIRM_DIFFERS=$?
fi

# Second, check if firmware file and programmer are present.
if [ -e ${MSPPROG} -a -e ${MSPFIRM} ]
then

  # Program only, if necessary.
  if [ ${MSPFIRM_DIFFERS} -ne 0 ]
  then

    # Detemine the IP Module ID.
    IPMODULE_ID=IM01
    if [ -f ${IPMODULE_ID_FILE} ]
    then
      IPMODULE_ID=$(cat ${IPMODULE_ID_FILE})
    fi

    # Now start the program process.
    ${MSPPROG} -f ${MSPFIRM} -m ${IPMODULE_ID} 2>&1 > ${MSPPROGRAM_LOGFILE}

    # If programmed correctly, create the hash file.
    if [ $? -eq 0 ]
    then
      cp ${MSPFIRM_EXPECTED_HASHFILE} ${MSPFIRM_ACTUAL_HASHFILE}
    fi

  else

    # Write log message in case that MSP firmware does not differ.
    echo "MSP firmware hash does not differ to installed one." > ${MSPPROGRAM_LOGFILE}

  fi

fi

# Write actual hash to log file, if exists
if [ -e ${MSPFIRM_ACTUAL_HASHFILE} ]
then
  echo "MSPFIRM_ACTUAL_HASHFILE   = $(tail -n 1 ${MSPFIRM_ACTUAL_HASHFILE})" >> ${MSPPROGRAM_LOGFILE}
else
  echo "MSPFIRM_ACTUAL_HASHFILE   = <FILE_DOES_NOT_EXISTS>" >> ${MSPPROGRAM_LOGFILE}
fi

# Write expected hash to log file, if exists
if [ -e ${MSPFIRM_EXPECTED_HASHFILE} ]
then
  echo "MSPFIRM_EXPECTED_HASHFILE = $(tail -n 1 ${MSPFIRM_EXPECTED_HASHFILE})" >> ${MSPPROGRAM_LOGFILE}
else
  echo "MSPFIRM_EXPECTED_HASHFILE = <FILE_DOES_NOT_EXISTS>" >> ${MSPPROGRAM_LOGFILE}
fi

# Start the KNX Stack.
/opt/gira/bin/knxstack $@
