local json = require("json")

function GetVersion()
  return 3
end

function GetCommands()
  return json.encode(
    {
      {
        type = "api",
        data = json.encode({command = "getdeviceconfig", ipc = true}),
        func = "HandleGetDeviceConfig"
      },
      {
        type = "api",
        data = json.encode({command = "GetUiConfiguration"}),
        func = "HandleGetUiConfig"
      }
    }
  )
end

function HandleGetDeviceConfig(response)
  local j = json.decode(response)
  local devcfg = GetFromTable(j, "response", "deviceConfig", "ipc")
  if devcfg
  then
    local fwv = GetFromTable(devcfg, "CurrentFirmwareVersion")
    local manu = GetFromTable(devcfg, "ManufacturerId")
    local device = GetFromTable(devcfg, "DeviceId")
    local revision = GetFromTable(devcfg, "ManufacturerRevision")
    if (revision == nil or revision == "")
    then
      revision = "unknown"
    end
    return json.encode({firmwareVersion = fwv, model = (manu .. device), manufacturerRevision = revision})
  end

  return ""
end

function HandleGetUiConfig(response)
  local j = json.decode(response)
  local cfg = GetFromTable(j, "response", "config")
  if cfg then
    local functions = {}
    for _, chv in ipairs(cfg) do
      local functionType = GetFromTable(chv, "functionType")
      local channelType = GetFromTable(chv, "channelType")
      if (functionType and channelType) then
        local key = functionType .. ":" .. channelType
        local count = functions[key]
        count = count and count + 1 or 1
        functions[key] = count
      end
    end
    
    local jsonFunctions = {}
    
    for key, count in pairs(functions) do
      local pos = key:find(':')
      local functionType = key:sub(0, pos - 1)
      local channelType = key:sub(pos + 1)
      
      table.insert(jsonFunctions, { functionType = functionType, channelType = channelType, count = count })
    end

    return json.encode({ functions = jsonFunctions })
  end

  return ""
end

function GetFromTable(tbl, key, ...)
  return not key and tbl or tbl[key] and GetFromTable(tbl[key], ...)
end
