#!/bin/sh

MSPPROG=/opt/gira/bin/mspprogram
MSPFIRM=/opt/gira/share/knxstack/msp/gira_linklayer_msp.a43
IPMODULE_ID_FILE=/opt/extparam/ipmodule_id
MSPPROGRAM_LOGFILE=/var/log/mspprogram.log

printf "Start of MSP programming sequence.\\n" > ${MSPPROGRAM_LOGFILE}

# Check if firmware file and programmer are present.
if [ -e ${MSPPROG} ] &&  [ -e ${MSPFIRM} ]
then
  # Detemine the IP Module ID.
  IPMODULE_ID=IM01
  if [ -f ${IPMODULE_ID_FILE} ]
  then
    IPMODULE_ID=$(cat ${IPMODULE_ID_FILE})
  fi
  printf "Detected IP Module ID for MSP programming is %s.\\n" "${IPMODULE_ID}" >> ${MSPPROGRAM_LOGFILE}

  # Now start the program process.
  ${MSPPROG} -f ${MSPFIRM} -m ${IPMODULE_ID} 2>&1 >> ${MSPPROGRAM_LOGFILE}

fi

trapFunction()
{
  trap - SIGHUP SIGINT SIGTERM
  kill $PID
  exit 0
}

# Start the KNX Stack.
/opt/gira/bin/knxstack $@ &
PID="$!"

trap trapFunction SIGHUP SIGINT SIGTERM

wait $PID

exit 0
