#!/bin/sh

# This special script writes to userdata only!
# The settings will survive updates, but not factory resets.

me="[$(printf $0 | xargs basename)]"

if [ ! -f "/opt/userdata/devicestack/shadow.template" ]; then
  if [ -f "/etc/init.d/S50dropbear" ]; then
    echo "${me} Enable SSH permanently"
    /etc/init.d/S50dropbear enable
  else
    echo "${me} /etc/init.d/S50dropbear does not exist"
  fi

  if [ -f "/etc/init.d/S15watchdog" ]; then
    echo "${me} Enable dummy watchdog trigger"
    /etc/init.d/S15watchdog enable
  else
    echo "${me} /etc/init.d/S15watchdog does not exist"
  fi

  if [ -f "/opt/gira/etc/devicestack/shadow.template.root" ]; then
    echo "${me} Resetting password to root..."
    # Any shadow template at this path has priority over the regular template
    mkdir -p /opt/userdata/devicestack/
    install -m 600 /opt/gira/etc/devicestack/shadow.template.root /opt/userdata/devicestack/shadow.template
    SHADOWLINK=$(readlink /etc/shadow)
    install -m 600 /opt/gira/etc/devicestack/shadow.template.root "${SHADOWLINK}"
  else
    echo "${me} /opt/gira/etc/devicestack/shadow.template.root does not exist"
  fi

  if [ -f "/opt/userdata/devicestack/users/device" ]; then
    echo "${me} Setting device:device password"
    echo "x8q+DQfMqM4+77LfeRWer2C0A5B2kZ4A4kIfAVeJvbw=" > /opt/userdata/devicestack/users/device
  else
    echo "${me} /opt/userdata/devicestack/users/device does not exist"
  fi
fi

exit 0
