local json = require("json")

function GetVersion()
  return 1
end

function GetCommands()
  return json.encode(
    {
      {
        type = "api",
        data = json.encode({command = "getdeviceconfig", ipc = true}),
        func = "HandleGetDeviceConfig"
      },
      {
        type = "api",
        data = json.encode({command = "GetUiConfiguration"}),
        func = "HandleGetUiConfig"
      },
      {
        type = "api",
        data = json.encode({command = "GetGiraOneDevices"}),
        func = "HandleGetGiraOneDevices"
      }
    }
  )
end

function HandleGetDeviceConfig(response)
  local j = json.decode(response)
  local devcfg = GetFromTable(j, "response", "deviceConfig", "ipc")
  if devcfg
  then
    local fwv = GetFromTable(devcfg, "CurrentFirmwareVersion")
    local manu = GetFromTable(devcfg, "ManufacturerId")
    local device = GetFromTable(devcfg, "DeviceId")
    local revision = GetFromTable(devcfg, "ManufacturerRevision")
    if (revision == nil or revision == "")
    then
      revision = "unknown"
    end
    return json.encode({firmwareVersion = fwv, model = (manu .. device), manufacturerRevision = revision})
  end

  return ""
end

function HandleGetUiConfig(response)
  local j = json.decode(response)
  local cfg = GetFromTable(j, "response", "config")
  if cfg then
    local functions = {}
    for _, chv in ipairs(cfg) do
      local functionType = GetFromTable(chv, "functionType")
      local channelType = GetFromTable(chv, "channelType")
      local channelTypeId = GetFromTable(chv, "channelTypeId")
      if (functionType and channelType and channelTypeId) then
        local key = functionType .. ":" .. channelType .. ":" .. channelTypeId
        local func = functions[key]
        if not func then
          func = { functionType = functionType, channelType = channelType, channelTypeId = channelTypeId, count = 0 }
        end
        local count = func['count']
        count = count + 1
        func['count'] = count
        functions[key] = func
      end
    end

    local jsonFunctions = {}

    for key, func in pairs(functions) do
      table.insert(jsonFunctions, func)
    end

    return json.encode({ functions = jsonFunctions })
  end

  return ""
end

function HandleGetGiraOneDevices(response)
  local j = json.decode(response)
  local devResponse = GetFromTable(j, "response", "devices")
  if devResponse then
    -- empty json object {} can't be encoded with json.lua, so handle this special case here
    if type(devResponse) ~= "table" or next(devResponse) == nil then
      return '{"devices":{}}'
    end

    return json.encode({ devices = devResponse })
  end

  return ""
end

function GetFromTable(tbl, key, ...)
  return not key and tbl or tbl[key] and GetFromTable(tbl[key], ...)
end
