#!/bin/sh
# Load ipmodule-functions for logging functions
. /opt/gira/share/devicestack/ipmodule-vars
. /opt/gira/share/devicestack/ipmodule-functions

STKNX="/opt/gira/bin/stknx"
STKNX_ADDITIONAL_ARGS_FILE=/opt/gira/etc/stknx/stknx-additional-args
RUN_STKNX=1
me="[$(printf $0 | xargs basename)]"

if [ -e ${STKNX_ADDITIONAL_ARGS_FILE} ]
then
{
  STKNX_ADDITIONAL_ARGS=$(cat ${STKNX_ADDITIONAL_ARGS_FILE})
}
fi

trapFunction()
{
  trap - SIGHUP SIGINT SIGTERM
  RUN_STKNX=0
  log ${me} "Stopping stknx PID=${STKNX_PID} ... "
  kill ${STKNX_PID}
  exit 0
}

trap trapFunction SIGHUP SIGINT SIGTERM

while [ ${RUN_STKNX} -eq 1 ]
do
  log ${me} "Starting/restarting stknx ... "
  nice -n -10 ${STKNX} --log_config_file=/opt/gira/etc/stknx/stknx-log4cplus.prop ${STKNX_ADDITIONAL_ARGS} &
  STKNX_PID="$!"
  log ${me} "PID=${STKNX_PID}"
  wait ${STKNX_PID}
  sleep 1
done

exit 0
