#!/bin/sh

# Load ipmodule variables
. /opt/gira/share/devicestack/ipmodule-vars

# if no partition is given, do not mount (and do not send mount-failed event)
test "${2#*p}" == "${2}" && exit 0

FSTYPE=$(lsblk -fno FSTYPE /dev/$2)

MOUNTOPTIONS="-o rw,sync,nosuid,nodev,noexec,noatime,nodiratime,fmask=0022,dmask=0022,shortname=mixed,utf8"

case ${FSTYPE} in 
  exfat)
    MOUNTOPTIONS="-o rw,sync,nosuid,nodev,noexec,noatime,nodiratime,fmask=0022,dmask=0022,utf8"
    ;;
  *)
    FSTYPE="vfat"
    ;;
esac 

if [ "$1" == "add" ]
then
  if [ -e "${NOCARD_FILE}" ]
  then
    ${MOUNT} -t ${FSTYPE} /dev/$2 ${MP_CARD} $MOUNTOPTIONS
    if [ "$?" -eq 0 ]
    then
      if [ -e "${NOCARD_FILE}" ]
      then
        # mount succeeded, but no card filesystem
        ${IPC_SEND} sdcard-no-filesystem
      else
        # mount succeeded and card filesystem available
        ${IPC_SEND} sdcard-in
      fi
    else
      # mount failed
      ${IPC_SEND} sdcard-mount-failed
    fi
  fi
fi

if [ "$1" == "remove" ]
then
  if [ ! -e "${NOCARD_FILE}" ]
  then
    # UNMOUNT CARD BEFORE IPC NOTIFY TO REDIRECT LOG FILE PATH
    ${UMOUNT} -l ${MP_CARD}
  fi
  ${IPC_SEND} sdcard-out
fi
