#!/bin/sh

. /opt/gira/share/devicestack/ipmodule-vars

update(){
  printf "Updating MCU firmware ...\\n"
  ${DCS_UPDATER} ${DCS_FIRMWARE}
  if [ $? -eq 0 ]
  then
    sha256sum ${DCS_FIRMWARE} > ${DCS_FIRMWARE_HASH} 
  else
    printf "Update failed!\\n"
  fi
}
    
# Update dcs firmware, if available
if [ -e ${DCS_UPDATER} ] && [ -e ${DCS_FIRMWARE} ]
then
  # Check if firmware versions differ, and if it has been updated before
  if [ ! -e ${DCS_FIRMWARE_HASH} ]
  then
    update
  else
    if [ "$(cat ${DCS_FIRMWARE_HASH})" != "$(sha256sum ${DCS_FIRMWARE})" ]
    then
      update
    fi
  fi
fi

trapFunction()
{
  trap - SIGHUP SIGINT SIGTERM
  kill $PID
  exit 0
}

/opt/gira/bin/dcsapp $@ &

PID="$!"

trap trapFunction SIGHUP SIGINT SIGTERM

wait $PID

exit 0
